# Reference VNF and NS Descriptors

## Reference NS#1: Testing an endpoint VNF

The following network service captures a simple test setup where a VNF is tested with a traffic generator VNF (or a simple VNF/VM with a basic client application). For simplicity, this network service assumes that the VNF under test is the endpoint of a given service (e.g. DNS, AAA, etc.) and does not require special conditions or resource allocation besides the usual in a standard cloud environments.

![Reference NS #1: Testing an endpoint VNF](assets/450px-Example_ns_1.png)

In this example, unless otherwise specified in the description, the following defaults apply:

- CPs are regular para-virtualized interfaces (VirtIO or equivalent).
- VLs provide E-LAN connectivity via regular (overlay) networks provided by the VIM.
- VLs provide IP addressing via DHCP if applicable.
- Mapping between internal and external CPs may be either direct (as aliases) or via an intermediate VL.
- VIM+NFVI can guarantee predictable ordering of guest interfaces' virtual PCI addresses.

In the case of REF_NS_1:

- When deploying the NS, VL1 would be typically mapped to a pre-created VIM network intended to provide management IP address to VNFs via DHCP.
- DHCP in VL2 may be optional.

### Reference VNF#11: Endpoint VNF

![Reference VNF#11: Endpoint](assets/350px-Ref_vnf_11.png)

#### Description in common language

- Name: Ref_VNF_11
  - Component: Ref_VM1
    - **Memory:** 2 GB
    - **CPU:** 2 vCPU
    - **Storage:** 8 GB
    - **Image:** ref_vm1.qcow2
  - Component: Ref_VM2
    - **Memory:** 4GB
    - **CPU:** 2 vCPU
    - **Storage:** 16GB
    - **Image:** ref_vm2.qcow2
  - Internal Virtual Link: VL12
    - No DHCP server is enabled.
    - Static addressing may be used at CP iface11 and CP iface21.

#### OSM VNF descriptor for VNF#11

[VNF11.yaml](https://osm.etsi.org/gitweb/?p=osm/devops.git;a=blob;f=descriptor-packages/vnfd/ref11_vnf/src/ref11_vnfd.yaml)

### Reference VNF#21: Generator 1 port

![Reference VNF#21: Generator 1 port](assets/350px-Ref_vnf_21.png)

#### Description in common language

- Name: Ref_VNF_21
  - Component: Ref_VM5
    - **Memory:** 1 GB
    - **CPU:** 1 vCPU
    - **Storage:** 16 GB
    - **Image:** ref_vm21.qcow2

#### OSM VNF descriptor for VNF#21

[VNF21.yaml](https://osm.etsi.org/gitweb/?p=osm/devops.git;a=blob;f=descriptor-packages/vnfd/ref21_vnf/src/ref21_vnfd.yaml)

### OSM NS descriptor for NS#1

[NS1.yaml](https://osm.etsi.org/gitweb/?p=osm/devops.git;a=blob;f=descriptor-packages/nsd/ref1_ns/src/ref1_nsd.yaml)

## Reference NS #2: Testing a middle point VNF

![Reference NS #2: Testing a middle point VNF](assets/400px-Example_ns_2.png)

The following network service captures a more advanced test setup where the VNF under test is a middlepoint in the communication (e.g. router, EPC) and might require special conditions or resource allocation and connectivity foreseen in NFV ISG specs. In this case, the traffic generator VNF behaves as source and sink of traffic and might also require special resource allocation.

In this example, unless otherwise specified in the description, the following applies:

- Same defaults as in NS#1
- vCPUs must be pinned to dedicated physical CPUs, with no over subscription.
- CPUs, memory and interfaces (if applicable) to be assigned to a given VM should belong to the same socket (NUMA awareness).
- Memory assigned to VMs should be backed by host's huge pages memory.
- VL2 and VL3 are E-Line underlay connectivity. No DHCP is required.

### Reference VNF#12: Middle point VNF

![Reference VNF#12: Middle point](assets/400px-Ref_vnf_12.png)

#### Description in common language

- Name: Ref_VNF_12
  - Component: Ref_VM3
    - **Memory:** 2 GB huge pages
    - **CPU:** 2 vCPU (= CPU)
    - **Storage:** 8 GB
    - **Image:** ref_vm3.qcow2
  - Component: Ref_VM4
    - **Memory:** 4GB
    - **CPU:** 2 vCPU
    - **Storage:** 16GB
    - **Image:** ref_vm4.qcow2
  - Connection Point: iface42 (west)
    - **Type:** Passthrough
  - Connection Point: iface43 (east)
    - **Type:** SR-IOV

#### OSM VNF descriptor for VNF#12

[VNF12.yaml](https://osm.etsi.org/gitweb/?p=osm/devops.git;a=blob;f=descriptor-packages/vnfd/ref12_vnf/src/ref12_vnfd.yaml)

### Reference VNF#22: Generator 2 ports

![Reference VNF#22: Generator 2 ports](assets/400px-Ref_vnf_22.png)

#### Description in common language

- Name: Ref_VNF_22
  - Component: Ref_VM6
    - **Memory:** 1 GB huge pages
    - **CPU:** 1 vCPU (= CPU)
    - **Storage:** 16 GB
    - **Image:** ref_vm22.qcow2
  - Connection Point: iface61 (west)
    - **Type:** Passthrough
  - Connection Point: iface62 (east)
    - **Type:** SR-IOV

#### OSM VNF descriptor for VNF#22

[VNF22.yaml](https://osm.etsi.org/gitweb/?p=osm/devops.git;a=blob;f=descriptor-packages/vnfd/ref22_vnf/src/ref22_vnfd.yaml)

### OSM NS descriptor for NS#2

[NS2.yaml](https://osm.etsi.org/gitweb/?p=osm/devops.git;a=blob;f=descriptor-packages/nsd/ref2_ns/src/ref2_nsd.yaml)

## Resources

The template used to create these NS/VNF diagrams is available at: [Reference_NS-VNF_diagrams.pptx](https://drive.google.com/open?id=0B0IUJnTZzp2iUnJUb1JFSGpBRGs)
